/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class EtchEngine
extends EnigmaEngine1 {
    EtchApplet etch;
    int x;
    int y;
    Graphics scr;
    long lastdisp = 0L;
    long helpdisp = 0L;
    int updatemouse = 0;
    int loc = 0;
    int SAND = -1127296;
    int WATER = -14671617;
    int FIRE = -49088;
    int WALL = -8355712;
    int PLANT = -14627808;
    int SPOUT = -9395969;
    int TORCH = -701681;
    int WELL = -12906480;
    int NITRO = -13339130;
    int NAPA = -1531362;
    int GUNP = -6453650;
    int CONC = -7626078;
    int C4 = -331108;
    int ICE = -4598273;
    int CERA = -1122868;
    int CERA2 = -1122867;
    int OIL = -8372160;
    int SALTWATER = -12549889;
    int SALT = -1;
    int METH = -16185079;
    int BLANK = -16777216;
    int FLASH = -1286;
    int ARBIT = -8891442;

    public EtchEngine(EtchApplet ea) {
        this.etch = ea;
        this.scr = this.etch.screen.getGraphics();
        this.setResolutionAct(ea.getWidth(), ea.getHeight());
        this.setOutputSizeAct(ea.getWidth(), ea.getHeight());
        this.bg.setColor(new Color(this.BLANK));
        this.bg.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        this.setFramerate(1000);
        this.x = this.etch.screen.getWidth() / 2;
        this.y = this.etch.screen.getHeight() / 2;
    }

    public void handleFrontBuffer() {
        long time = System.currentTimeMillis();
        if (time - this.lastdisp < 2000L) {
            this.etch.element.setVisible(true);
            this.etch.pensize.setVisible(true);
            this.etch.gamespeed.setVisible(true);
        } else {
            this.etch.element.setVisible(false);
            this.etch.pensize.setVisible(false);
            this.etch.gamespeed.setVisible(false);
        }
        if (System.currentTimeMillis() - this.helpdisp < 16000L) {
            this.etch.about.setVisible(true);
        } else {
            this.etch.about.setVisible(false);
        }
        this.etch.screen.paintComponents(this.bfg);
        this.bfg.setColor(Color.black);
        this.bfg.drawRect(this.x - 2, this.y - 2, 4, 4);
        this.bfg.setColor(Color.white);
        this.bfg.drawLine(this.x, this.y - 2, this.x, this.y + 2);
        this.bfg.drawLine(this.x - 2, this.y, this.x + 2, this.y);
        this.scr.drawImage(this.frontbuffer, 0, 0, this.owidth, this.oheight, 0, 0, this.width, this.height, null);
    }

    public void updateMain() {
        this.bg.setColor(new Color(this.WALL));
        this.bg.drawLine(0, 0, 0, this.height);
        this.bg.drawLine(this.width - 1, 0, this.width - 1, this.height);
        this.bg.setColor(new Color(this.BLANK));
        this.bg.drawLine(0, this.height - 1, this.width, this.height - 1);
        if (this.updatemouse == 0) {
            if (this.etch.ml) {
                --this.x;
                if (this.x < 0) {
                    this.x = this.width - 1;
                }
            }
            if (this.etch.mr) {
                this.x = (this.x + 1) % this.width;
            }
            if (this.etch.mu) {
                --this.y;
                if (this.y < 0) {
                    this.y = this.height - 1;
                }
            }
            if (this.etch.md) {
                this.y = (this.y + 1) % this.height;
            }
        }
        if (this.etch.dr) {
            this.bg.setColor(new Color(this.etch.colors[this.etch.eindex]));
            int psize = this.etch.pensizes[this.etch.pindex];
            this.bg.fillOval(this.x - psize / 2, this.y - psize / 2, psize, psize);
        }
        this.etch.updateLabels();
    }

    public void processSandParticle(int i) {
        if (this.pixels[i] == this.BLANK) {
            return;
        }
        switch (0xFF000000 | this.pixels[i]) {
            case -8355712: {
                return;
            }
            case -1127296: {
                if (this.fallingRule(i, true) || this.densityRule(i, this.WATER, 0.25)) break;
                return;
            }
            case -14671617: {
                if (this.combineRule(i, this.SALT, this.SALTWATER, 0.25) || this.densityRule(i, this.OIL, 0.25) || this.fallingRule(i, true)) break;
                return;
            }
            case -49088: {
                int loc2 = 0;
                if (this.ch(0.2) && (this.loc = this.select(i, this.PLANT, 255)) != -1) {
                    this.pixels[this.loc] = this.FIRE;
                    break;
                }
                if (this.ch(0.01) && (this.loc = this.select(i, this.CERA, 15)) != -1) {
                    this.pixels[i] = this.FIRE;
                    this.pixels[this.loc] = this.FIRE;
                    loc2 = this.select(Math.max(i, this.loc), this.BLANK, 8);
                    if (loc2 == -1) break;
                    this.pixels[loc2] = this.CERA2;
                    break;
                }
                if (this.ch(0.4) && this.select(i, this.PLANT, 255) == -1 && this.select(i, this.CERA, 15) == -1) {
                    this.pixels[i] = this.BLANK;
                    break;
                }
                if (this.ch(0.8) && (this.loc = this.select(i, this.WATER, 255)) != -1) {
                    this.pixels[this.loc] = this.BLANK;
                    this.pixels[i] = this.BLANK;
                    break;
                }
                if (this.ch(0.5) && (this.loc = this.select(i, this.BLANK, 4)) > -1) {
                    this.pixels[this.loc] = this.FIRE;
                }
                return;
            }
            case -14627808: {
                if (this.growRule(i, this.WATER, 0.5)) break;
                return;
            }
            case -9395969: {
                this.doSpigot(i, this.WATER, 0.05);
                return;
            }
            case -1122867: {
                this.loc = this.select(i, this.BLANK, 8);
                if (this.loc != -1) {
                    this.swap(i, this.loc);
                    break;
                }
                this.loc = this.select(i, this.BLANK, 192);
                if (this.loc != -1) {
                    this.swap(i, this.loc);
                    break;
                }
                this.pixels[i] = this.CERA2;
                break;
            }
            case -12549889: {
                if (this.fallingRule(i, true) || this.densityRule(i, this.WATER, 0.5)) break;
                return;
            }
            case -8372160: {
                if (this.ch(0.3) && (this.loc = this.select(i, this.FIRE, 15)) != -1) {
                    this.doOilFire(i);
                    break;
                }
                if (this.fallingRule(i, true)) break;
                return;
            }
            case -1: {
                if (this.fallingRule(i, true)) break;
                return;
            }
            case -701681: {
                return;
            }
            case -1122868: {
                return;
            }
            default: {
                return;
            }
        }
        this.scrambleSelectors();
    }

    void doOilFire(int i) {
        if (i - this.width > -1) {
            this.pixels[i - this.width] = this.FIRE;
        }
        this.pixels[i + this.width] = this.FIRE;
        this.pixels[i + 1] = this.FIRE;
        this.pixels[i - 1] = this.FIRE;
        this.pixels[i] = this.FIRE;
    }

    public void swap(int j, int k) {
        int i = this.pixels[j];
        this.pixels[j] = this.pixels[k];
        this.pixels[k] = i;
    }

    boolean densityRule(int i, int comcolor, double chance) {
        int loc = 0;
        if (this.ch(chance) && (loc = this.select(i, comcolor, 200)) != -1) {
            this.pixels[loc] = this.pixels[i];
            this.pixels[i] = comcolor;
            return true;
        }
        return false;
    }

    boolean combineRule(int i, int comcolor, int resultcolor, double chance) {
        int loc = 0;
        if (this.ch(chance) && (loc = this.select(i, comcolor, 15)) != -1) {
            this.pixels[i] = this.BLANK;
            this.pixels[loc] = resultcolor;
            return true;
        }
        return false;
    }

    boolean growRule(int i, int comcolor, double chance) {
        int loc = 0;
        if (this.ch(chance) && (loc = this.select(i, comcolor, 255)) != -1) {
            this.pixels[loc] = this.pixels[i];
            return true;
        }
        return false;
    }

    boolean fallingRule(int i, boolean adjacent) {
        int loc = 0;
        if (this.ch(0.95) && (loc = this.select(i, this.BLANK, 8)) != -1) {
            this.swap(i, loc);
            return true;
        }
        if (this.ch(0.45) && (loc = this.select(i, this.BLANK, 192)) != -1) {
            this.swap(i, loc);
            return true;
        }
        if (this.ch(0.05) && (loc = this.select(i, this.BLANK, 3)) != -1) {
            this.swap(i, loc);
            return true;
        }
        return false;
    }

    void doSpigot(int i, int type, double rate) {
        if (this.ch(rate)) {
            if (i - this.width > -1 && this.pixels[i - this.width] == this.BLANK) {
                this.pixels[i - this.width] = type;
            }
            if (this.pixels[i + this.width] == this.BLANK) {
                this.pixels[i + this.width] = type;
            }
            if (this.pixels[i + 1] == this.BLANK) {
                this.pixels[i + 1] = type;
            }
            if (this.pixels[i - 1] == this.BLANK) {
                this.pixels[i - 1] = type;
            }
        }
    }

    void doSpigot2(int i, int type, double rate) {
        if (this.ch(rate)) {
            if (i - this.width > -1) {
                this.pixels[i - this.width] = type;
            }
            this.pixels[i + this.width] = type;
            this.pixels[i + 1] = type;
            this.pixels[i - 1] = type;
        }
    }

    public boolean ch(double ch) {
        return Math.random() < ch;
    }
}

